#include <Servo.h>    // Servo-Bibliothek einbinden
Servo myServo;        // Ein Servoobjekt namens "myServo" anlegen

int rohwert = 0;      // Variable für den Rohwert des analogen Pins A0
float V_analogerPin = 0.0;  // Variable für die Spannung, die aus dem Spannungsteiler rausgeht (also die Spannung, die am Pin anliegt)
float V_klemmen = 0.0;      // Variable für die Spannung, die an den Spannungsteiler angelegt wird (also die Spannung, die an den Krokoklemmen angelegt wird)
float R1 = 33000.0;   // Widerstandswert R1 (33k)
float R2 = 10000.0;   // Widerstandswert R2 (10k)
int Winkel = 0;       // Variable für den Winkel des Servomotors



void setup() {
  Serial.begin(9600);     // Seriellen Monitor einbinden
  
  pinMode (12, OUTPUT);   // Digitalen Pin 12 als Ausgang festlegen
  myServo.attach(12);     // myServo den Pin 12 zuordnen

  pinMode(A0, INPUT);     // Analogen Pin 0 als Eingang festlegen. Hier findet die Messung der Batterien per Krokoklemmen statt.
                          // Analoge Pins geben einen Wert von 0 bis 1023 wieder (haben also eine Auflösung von 1024 Schritten). 
                          // Der Wert ist abhängig von der anliegenden Spannung: 0 = 0V und 1023 = 5V. Entsprechend muss umgerechnet werden
}


void loop() {
  rohwert = analogRead(A0);   // Messwerte am analogen Pin 0 als "rohwert" definieren
  
  Serial.print("rohwert = ");
  Serial.println(rohwert);    // Messwerte am anologen Pin im seriellen Monitor anzeigen

  Winkel = 0;
  myServo.write(Winkel);      // Winkel des Servomotors einstellen

}


/*  P7_Stromteiler-Gleichstrom-Voltmeter 0 - 20V _ 14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************

    1   VORBEREITUNG - Laden Sie diesen Sketch unverändert auf den Arduino hoch.
        Stecken Sie den Zeiger so auf den Servomotor, dass er nach rechts zeigt, wenn Sie frontal auf die Anzeige schauen.


    2   ROHWERT IN SPANNUNG UMRECHNEN UND AUSGEBEN - Lassen Sie den Rohwert in eine Spannung umrechnen mithilfe des folgenden Befehls:   V_analogerPin = (5.0 / 1024.0) * rohwert; 
        Kopieren Sie den Code an eine geeignete Stelle. Geben Sie die Spannung statt des Rohwertes auf dem seriellen Monitor aus.


    3   SPANNUNG AM EINGANG BERECHNEN - Berechnen Sie nun, welche Spannung am Eingang des Spannungsteilers anliegt. Schauen Sie sich dafür das Handout mit den Erläuterungen an.
    
        Weisen Sie der Variable "V_klemmen" die gemessene Spannung zu. Die Widerstandswerte R1 und R2 sind bereits über dem Setup definiert.
        Geben Sie die Spannung auf dem seriellen Monitor aus.
        Testen Sie Ihr Messgerät, indem Sie die Spannung verschiedener Batterietypen messen (<10V). 

        Hinweis: Weiter unten in den Lösungshinweisen gibt es auch einen Beispielcode.

    4   SERVOMOTOR STEUERN - Ändern Sie die Position des Zeigers, indem Sie die Variable Winkel oder den Befehl myServo.write(); anpassen.
        Finden Sie den maximal einzustellenden Winkel des Zeigers heraus. Wenn der Motor durchgehend knackt oder bei höheren Winkeln nicht mehr weitergeht, ist der maximale Winkel überschritten worden.

        Tipp: Tragen Sie die Winkelwerte auf der Skala mit dem abwaschbaren Stift ein.

    5   EINGANGSSPANNUNG UND AUSSCHLAG DES ZEIGERS KOPPELN - Machen Sie sich dazu mit der Funktion map() vertraut (Lösungshinweise oder Internetrecherche, z.B.: https://www.arduino.cc/reference/en/language/functions/math/map/). 
    

    6   BESTIMMTE MESSPUNKTE MARKIEREN - Ändern Sie den Sketch so, dass die Spannung auf 1,5V (4,5V, 9V und 0V) festgelegt ist, bevor der Servo angesteuert wird.
        Markieren Sie die Stellen auf dem Anzeigeblatt mit einem wasserlöslichen Folienstift.
    
        
    7   MESSGERÄT TESTEN - Testen Sie Ihr Messgerät, indem Sie die Spannung verschiedener Batterietypen messen (<10V).


    8   ANZEIGE UMKEHREN (EXPERTENAUFGABE) - Viele Anzeigen, z.B. die Geschwindigkeitsanzeige im Auto, zeigen im Uhrzeigersinn höhere Werte an.
        Ändern Sie Ihren Sketch, die Zeigernadel und die Anzeigebeschriftung so, dass höhere Werte im Uhrzeigersinn angezeigt werden. Wenn der Zeiger nach links zeigt, soll er auf 0V zeigen.

    
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************

    3   SPANNUNG AM EINGANG BERECHNEN - V_klemmen = V_analogerPin * (R1 + R2) / R2;
    
    
    4   SERVOMOTOR STEUERN - Ändern Sie die Zahl hinter der Variable "Winkel". Der maximale Ausschlag liegt bei den meisten SG-90-Servomotoren bei ca. 170.


    5   EINGANGSSPANNUNG UND AUSSCHLAG DES ZEIGERS KOPPELN - Die Funktion map() wandelt Werte von einem Wertebereich in einen anderen um. Sie benötigt dafür fünf Argumente.

        map(zu skalierende Variable, Mindestwert der Eingabe, Höchstwert der Eingabe, Mindestwert der Ausgabe, Höchstwert der Ausgabe);

        Die zu skalierende Variable ist V_klemmen. Aus ihr ergibt sich die Eingabe. Der erste Wertebereich (Eingabe) geht von 0-10V, der zweite (Ausgabe) von 0-170° bzw. dem größten Winkel, der eingestellt werden kann.
        Weisen Sie der Variable "Winkel" den Wert aus map() zu.


    6   BESTIMMTE MESSPUNKTE AUF SKALA MARKIEREN - Weisen Sie "V_klemmen" vor der map()-Funktion die genannten Werte zu. Nutzen Sie Punkte statt Kommata (also 4.5 statt 4,5).
        Tragen Sie diese Messpunkte mit einem abwaschbaren Stift auf der Skala ein.


    8   ANZEIGE UMKEHREN (EXPERTENAUFGABE) - Drehen Sie die Ausgabewerte in der Funktion map() um. Die Funktion skaliert nun invertiert.
     

    **********************************************************
    LÖSUNGEN
    **********************************************************

    3   SPANNUNG AM EINGANG BERECHNEN

        rohwert = analogRead(A0);         // Messwerte am analogen Pin 0 als "rohwert" definieren
        V_analogerPin = (5.0 / 1024.0) * rohwert;     // "rohwert" in eine Spannung umrechnen und "V_klemmen" zuweisen.
        V_klemmen = V_analogerPin * (R1 + R2) / R2;   // Berechnen, welche Spannung am Eingang des Spannungsteilers anliegt. 
        if (V_klemmen < 0.09) {
          V_klemmen = 0.0;                      // Unterdrücken unerwünschter Anzeigen
        }

    5   EINGANGSSPANNUNG UND AUSSCHLAG DES ZEIGERS KOPPELN

        Winkel = map(V_klemmen, 0, 10, 0, 170);
        myServo.write(Winkel);

    6   BESTIMMTE MESSPUNKTE MARKIEREN

        rohwert = analogRead(A0);         // Messwerte am analogen Pin 0 als "rohwert" definieren
        V_analogerPin = (5.0 / 1024.0) * rohwert;   // "rohwert" in eine Spannung umrechnen und "V_klemmen" zuweisen.
        V_klemmen = V_analogerPin * (R1 + R2) / R2;    // Berechnen, welche Spannung am Eingang des Spannungsteilers anliegt.
        
        if (V_klemmen < 0.09) {
          V_klemmen = 0.0;                      // Unterdrücken unerwünschter Anzeigen
        }
        
        V_klemmen = 1.5; // bzw. 4.5 bzw. 9.0 bzw. 0.0
        Winkel = map(V_klemmen, 0, 10, 0, 170);
        myServo.write(Winkel);

    8   ANZEIGE UMKEHREN (EXPERTENAUFGABE)

        Winkel = map(V_klemmen, 0, 10, 170, 0);

*/
